#include <iostream>
#include <algorithm>
#include <vector>
#include <queue>
#include <climits>

using namespace std;

bool in[100005];

struct P {
	int x;
	int y;
	int z;
};

bool operator<(P a, P b) {
	return a.z < b.z;
}

const int N = 1 << 17;
int T[2 * N];

void set(int i, int v) {
	i += N;
	T[i] = v;
	i >>= 1;
	while(i) {
		T[i] = min(T[2 * i], T[2 * i + 1]);
		i >>= 1;
	}
}

int get(int v) {
	int ret = INT_MAX;
	v += N;
	while(v > 1) {
		if(v & 1) ret = min(ret, T[v - 1]);
		v >>= 1;
	}
	return ret;
}

int main() {
	cin.sync_with_stdio(false);
	
	int Tx;
	cin >> Tx;
	
	for(int sd = 0; sd < Tx; ++sd) {
		int n;
		cin >> n;
		
		vector<P> points;
		for(int i = 0; i < n; ++i) {
			int a1, a2, a3;
			cin >> a1 >> a2 >> a3;
			--a1;
			--a2;
			--a3;
			points.push_back(P{a1, a2, a3});
		}
		sort(points.begin(), points.end());
		
		fill(T, T + 2 * N, INT_MAX);
		
		int cnt = 0;
		for(P p : points) {
			if(get(p.x) > p.y) ++cnt;
			set(p.x, p.y);
		}
		cout << cnt << "\n";
	}
	
	return 0;
}
